{
	tutorials [

	{
		id 		 "tutorial1"
		locname  "tutorial1.name"
		locdesc  "tutorial1.desc"
		filename "Tutorial/Tutorial1"
		actions [
			{ #type tut-show-info lockey "tut.intro" type middlecenter blocking #true portrait 3 }

			{ #type tut-show-info lockey "tut.camera.1" portrait 3 }
			{ #type tut-wait-for-camera posdelta 10 }
			{ #type tut-show-info lockey "tut.camera.2" portrait 3 }

			{ #type tut-wait-for-camera zoomdelta 10 }

			;; click office button

			{ #type tut-show-info lockey "tut.office.1" blocking #true portrait 3 }
			{ #type tut-pan-camera pos { x 2 y 1 } blocking #true }

			{ #type tut-show-info lockey "tut.office.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.offices" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-offices" }

			;; click small office button

			{ #type tut-hide-arrow }
			{ #type tut-skip-frames count 5 }
			{ #type tut-show-arrow type down uiname "ui.build.office.4w" offset { x 24 y 40 } }
			{ #type tut-show-info lockey "tut.office.3" portrait 3 }

			{ #type tut-wait-for-buy-entity-input-mode template "emptyspace-office-4w" }

			;; place empty space in the right spot

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.office.4" portrait 3 }
			{ #type tut-show-highlight pos { x -1 y 1 } size { x 4 y 1 } }

			{ #type tut-wait-for-entity-count template "emptyspace-office-4w" count 1 }

			;; wait for exit input mode

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut.office.5" type topcenter portrait 3 }
			{ #type tut-wait-for-default-input-mode }

			;; start move-ins

			{ #type tut-show-arrow type down pos { x 1 y 1.7 } }
			{ #type tut-show-info lockey "tut.movein.1" type topcenter portrait 3 }

			{ #type tut-wait-for-dialog type moveinads showing #true }

			;; show the different types of tenants

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.movein.2" type topcenter portrait 3 }
			{ #type tut-wait-for-dialog type moveintenants showing #true }

			;; show the choice of tenants

			{ #type tut-show-info lockey "tut.movein.3" type topcenter portrait 3 }
			{ #type tut-wait-for-dialog type moveintenants showing #false }

			;; and now we wait to build

			{ #type tut-show-info lockey "tut.movein.4" type topright blocking #true portrait 3 }
			{ #type action-pause simseconds 3 }

			;; speed tutorial

			{ #type tut-show-info lockey "tut.speed.1" type topcenter portrait 3 }
			{ #type tut-show-arrow type left uiname "SpeedButton3" offset { x 40 y -15 } }

			{ #type tut-wait-for-game-speed type high }

			;; wait for construction

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.speed.2" type topcenter portrait 3 }

			{ #type tut-wait-for-all-unit-construction-done }

			;; slow back down

			{ #type tut-show-info lockey "tut.speed.3" type topcenter portrait 3 }
			{ #type tut-show-arrow type left uiname "SpeedButton2" offset { x 40 y -15 } }
			{ #type tut-wait-for-game-speed type normal }

			;; display blocking info dialog

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.speed.4" blocking #true portrait 3 }

			{ #type tut-force-unpause } ;; just in case the player left it paused

			;;
			;; expand the building horizontally

			;; click on build button

			{ #type tut-pan-camera pos { x 4 y 0 } blocking #true }
			{ #type tut-show-info lockey "tut.expand.1" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" }

			;; click on floor button

			{ #type tut-show-info lockey "tut.expand.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor.floor" offset { x 24 y 40 } }

			{ #type tut-wait-for-add-floor-input-mode }

			;; build floor in specified area

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.expand.3" portrait 3 }
			{ #type tut-show-highlight pos { x 3 y 0 } size { x 4 y 1 } }

			{ #type tut-wait-for-floor pos { x 3 y 0 } size { x 4 y 1 } }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut.expand.4" type topcenter portrait 3 }
			{ #type tut-wait-for-default-input-mode }


			;; switch to utilities ribbon

			{ #type tut-show-info lockey "tut.utilities.1" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.utilities" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" }

			;; click on add power button

			{ #type tut-show-info lockey "tut.utilities.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.util.power.add" offset { x 24 y 40 } }

			{ #type tut-wait-for-add-utility-input-mode type utilpower }

			;; build pipes in specified area

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.utilities.3" portrait 3 }
			{ #type tut-show-highlight pos { x 3 y 0 } size { x 4 y 1 } }

			{ #type tut-wait-for-utilities pos { x 3 y 0 } size { x 4 y 1 } type utilpower }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut.utilities.4" type topcenter portrait 3 }

			{ #type tut-wait-for-default-input-mode }

			;; wait for the floor to be finished

			{ #type tut-show-info lockey "tut.utilities.5" portrait 3 }
			{ #type tut-wait-for-floor pos { x 3 y 0 } size { x 4 y 1 } finishedonly #true }



			;; switch to the restaurant ribbon

			{ #type tut-pan-camera pos { x 4 y 0 } }
			{ #type tut-show-info lockey "tut.rest.1" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.restaurants" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-restaurants" }

			;; click small restaurant button

			{ #type tut-skip-frames count 5 }
			{ #type tut-show-arrow type down uiname "ui.build.restaurant.4w" offset { x 24 y 40 } }
			{ #type tut-show-info lockey "tut.rest.2" portrait 3 }

			{ #type tut-wait-for-buy-entity-input-mode template "emptyspace-restaurant-4w" }


			;; wait for placement

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.rest.3" portrait 3 }
			{ #type tut-show-highlight pos { x 3 y 0 } size { x 4 y 1 } }
			{ #type tut-wait-for-entity-count template "emptyspace-restaurant-4w" count 1 }

			{ #type tut-hide-highlight }
			{ #type tut-wait-for-default-input-mode }

			;; and wait for player declaring they want to move on

			{ #type tut-show-info lockey "tut.rest.4" type topcenter portrait 3 }
			{ #type tut-wait-for-entity-count template "emptyspace-restaurant-4w" count 0 test exactly }


			;;
			;;
			;; add new top floor

			;; intro and wait for build ribbon

			{ #type tut-show-info lockey "tut.floor.1" blocking #true portrait 3 }

			{ #type tut-pan-camera pos { x 2 y 2 } blocking #true }
			{ #type tut-show-info lockey "tut.floor.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" }

			;; click on build button

			{ #type tut-show-info lockey "tut.floor.3" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor.floor" offset { x 24 y 40 } }

			{ #type tut-wait-for-add-floor-input-mode }

			;; build floor in specified area

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.floor.4" portrait 3 }
			{ #type tut-show-highlight pos { x -9 y 2 } size { x 12 y 1 } }

			{ #type tut-wait-for-floor pos { x -9 y 2 } size { x 12 y 1 } }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-wait-for-default-input-mode }




			;; build button again (for the elevator)

			{ #type tut-show-info lockey "tut.elev.1" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" }

			;; elevator button

			{ #type tut-show-info lockey "tut.elev.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.floor.elevator" offset { x 24 y 40 } }

			{ #type tut-wait-for-buy-entity-input-mode template path-elevator }

			;; build elevator

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.elev.3" portrait 3 }
			{ #type tut-show-highlight pos { x -9 y 2 } size { x 3 y 1 } }

			{ #type tut-wait-for-entity-count template path-elevator count 3 test atleast }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut.elev.4" portrait 3 }
			{ #type tut-wait-for-default-input-mode }


			;; switch to utilities ribbon

			{ #type tut-show-info lockey "tut.closet.1" blocking #true portrait 3 }

			{ #type tut-show-info lockey "tut.closet.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.utilities" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" }

			;; pick electrical closet

			{ #type tut-show-info lockey "tut.closet.3" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.util.power.closet" offset { x 24 y 40 } }

			{ #type tut-wait-for-buy-entity-input-mode template closet-electrical }

			;; place it in the right spot

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.closet.4" portrait 3 }
			{ #type tut-show-highlight pos { x -6 y 2 } size { x 1 y 1 } }

			{ #type tut-wait-for-entity-count template closet-electrical count 3 test atleast }
			{ #type tut-wait-for-default-input-mode }
			{ #type tut-hide-highlight }

			;; utilities on the new floor

			;; utilities ribbon again (in case it went away)

			{ #type tut-show-info lockey "tut.floorutils.1" blocking #true portrait 3 }
			
			{ #type tut-show-info lockey "tut.floorutils.2" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.utilities" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" }

			;; click on the add power button again

			{ #type tut-show-info lockey "tut.floorutils.3" portrait 3 }
			{ #type tut-show-arrow type down uiname "ui.build.util.power.add" offset { x 24 y 40 } }

			{ #type tut-wait-for-add-utility-input-mode type utilpower }

			;; build pipes in specified area

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut.floorutils.4" portrait 3 }
			{ #type tut-show-highlight pos { x -5 y 2 } size { x 8 y 1 } }

			{ #type tut-wait-for-utilities pos { x -5 y 2 } size { x 8 y 1 } type utilpower }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut.floorutils.5" type topcenter portrait 3 }

			{ #type tut-wait-for-default-input-mode }


			;;
			;; epilogue 

			;; wait for the floor to be finished

			{ #type tut-show-info lockey "tut.epilogue.1" blocking #true portrait 3 }
			{ #type tut-show-info lockey "tut.epilogue.2" blocking #true type topcenter portrait 3 }
			{ #type tut-exit }

		]
	}

	{
		id 		 "tutorial2"
		locname  "tutorial2.name"
		locdesc  "tutorial2.desc"
		filename "Tutorial/Tutorial2"
		actions [

			{ #type tut-show-info lockey "tut2.intro" type middlecenter blocking #true portrait 2 }


			{ #type tut-pan-camera pos { x 6 y 3 } blocking #true }
			{ #type tut-show-info lockey "tut2.phone.1" blocking #true portrait 2 }

			;; switch to utilities ribbon

			{ #type tut-show-info lockey "tut2.phone.2" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.utilities" offset { x 24 y 40 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" }

			;; switch to phone tab

			{ #type tut-show-info lockey "tut2.phone.3" portrait 2 }
			{ #type tut-show-arrow type right uiname "subribbon-utilities-phone" offset { x 15 y 12 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" tabid "subribbon-utilities-phone" }

			;; click on add phone button

			{ #type tut-show-info lockey "tut2.phone.4" portrait 2 }
			{ #type tut-show-arrow type right uiname "ui.build.util.phone.add" offset { x 10 y 28 } }
			{ #type tut-wait-for-add-utility-input-mode type utilphone }

			;; build phone lines in specified area

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.phone.5" portrait 2 }
			{ #type tut-show-highlight pos { x 2 y 3 } size { x 5 y 1 } }

			{ #type tut-wait-for-utilities pos { x 2 y 3 } size { x 5 y 1 } type utilphone }

			;; right click again

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut2.phone.6" type topcenter portrait 2 }

			{ #type tut-wait-for-default-input-mode }


			;; phone switchboard

			{ #type tut-show-info lockey "tut2.switch.1" blocking #true portrait 2 }

			{ #type tut-pan-camera pos { x 4 y -2 } blocking #true }
			{ #type tut-show-info lockey "tut2.switch.2" blocking #true portrait 2 }

			;; switch to utilities ribbon

			{ #type tut-show-info lockey "tut2.switch.3" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.utilities" offset { x 24 y 40 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" }

			;; switch to phone tab

			{ #type tut-show-info lockey "tut2.switch.4" portrait 2 }
			{ #type tut-show-arrow type right uiname "subribbon-utilities-phone" offset { x 15 y 15 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-utilities" tabid "subribbon-utilities-phone" }

			;; click on small switchboard

			{ #type tut-show-info lockey "tut2.switch.5" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.util.phone.meter1" offset { x 24 y 40 } }
			{ #type tut-wait-for-buy-entity-input-mode template closet-phonemeter-l1 }

			;; highlight placement

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.switch.6" portrait 2 }
			{ #type tut-show-highlight pos { x 5 y -2 } size { x 2 y 1 } }

			{ #type tut-wait-for-entity-count template closet-phonemeter-l1 count 1 test atleast }

			;; finish

			{ #type tut-hide-highlight }
			{ #type tut-force-util-input-mode type utilphone }
			{ #type tut-show-info lockey "tut2.switch.7" blocking #true portrait 2 }

			{ #type tut-force-default-input-mode }
			{ #type tut-pan-camera pos { x 6 y 3 } blocking #true }
			{ #type tut-show-info lockey "tut2.switch.8" blocking #true portrait 2 }



			;; overlays

			;; click to show overlays

			{ #type tut-pan-camera pos { x 0 y 1 } zoom 700 blocking #true }

			{ #type tut-show-info lockey "tut2.overlays.1" portrait 2 }
			{ #type tut-show-arrow type up uiname "Maps Button" offset { x 20 y 0 } }

			{ #type tut-wait-for-dialog type overlaysribbon showing #true }

			;; wait for user selection

			{ #type tut-show-info lockey "tut2.overlays.2" portrait 2 }
			{ #type tut-show-arrow type left uiname "Happiness" offset { x 20 y 0 } }

			{ #type tut-wait-for-heatmap type "satisfactionHeatmap" }

			;; pan over, wait for overlay over

			{ #type tut-hide-arrow }
			{ #type tut-hide-info }
			{ #type tut-skip-frames count 10 }
			{ #type tut-pan-camera pos { x -2 y 2 } zoom 400 blocking #true }

			{ #type tut-show-info lockey "tut2.overlays.3" portrait 2 }
			{ #type tut-show-arrow type left uiname "Maps Off" offset { x 20 y 0 } }
			{ #type tut-wait-for-heatmap type "disabled" }

			;; wait for selection

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.overlays.4" portrait 2 }
			{ #type tut-show-arrow type down pos { x -4 y 2.55 } }

			{ #type tut-wait-for-dialog type unitinfo showing #true }

			;; explanations

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.service.1" type topcenter blocking #true portrait 2 }

			{ #type tut-show-info lockey "tut2.service.2" type topcenter portrait 2 }
			{ #type tut-wait-for-dialog type unitinfo showing #false }

			;; services button

			{ #type tut-hide-info }
			{ #type tut-pan-camera pos { x 2 y -1 } blocking #true }

			{ #type tut-show-info lockey "tut2.service.3" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.services" offset { x 24 y 40 } }

			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-services" }

			;; pick commercial services

			{ #type tut-show-info lockey "tut2.service.4" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.services.office" offset { x 24 y 40 } }

			{ #type tut-wait-for-dialog type moveinservices showing #true }

			;; pick the right service

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.addserv.1" portrait 2 }

			{ #type tut-wait-for-buy-entity-input-mode template service-level-one-water }

			;; wait for placement

			{ #type tut-show-info lockey "tut2.addserv.2" portrait 2 }
			{ #type tut-show-highlight pos { x -1 y -1 } size { x 5 y 1 } }

			{ #type tut-wait-for-entity-count template service-level-one-water count 1 test atleast }

			;; finish 

			{ #type tut-show-info lockey "tut2.addserv.3" portrait 2 }
			{ #type tut-wait-for-default-input-mode }

			{ #type tut-hide-highlight }
			{ #type tut-hide-info }
			{ #type tut-pan-camera pos { x 2 y -1 } zoom 600 seconds 2 blocking #true }


			;;
			;; budget intro

			;; wait for click

			{ #type tut-show-info lockey "tut2.budget.1" type topcenter portrait 2 }
			{ #type tut-show-arrow type down uiname "MoneyText" offset { x 50 y 10 } }
			{ #type tut-wait-for-dialog type budget showing #true }

			;; explain budget and close

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut2.budget.2" portrait 2 }
			
			{ #type tut-wait-for-dialog type budget showing #false }

			;; pan and wait for tenant click

			{ #type tut-hide-info }
			{ #type tut-pan-camera pos { x 2 y 1 } blocking #true }
			{ #type tut-show-info lockey "tut2.budget.3" portrait 2 }

			{ #type tut-wait-for-dialog type unitinfo showing #true }

			;; wait for close 

			{ #type tut-show-info lockey "tut2.budget.4" type topcenter portrait 2 }

			{ #type tut-wait-for-dialog type unitinfo showing #false }


			;; outro

			{ #type tut-show-info lockey "tut2.epilogue.1" blocking #true portrait 2 }
			{ #type tut-show-info lockey "tut2.epilogue.2" blocking #true type topcenter portrait 2 }
			{ #type tut-exit }

		]
	}



	{
		id 		 "tutorial3"
		locname  "tutorial3.name"
		locdesc  "tutorial3.desc"
		filename "Tutorial/Tutorial3"
		actions [

			;{ #type tut-hide-button-highlights }			
			{ #type tut-pan-camera pos { x 0 y 2 } blocking #false seconds 0 }
			{ #type tut-show-info lockey "tut3.intro" type middlecenter blocking #true portrait 2 }
			{ #type tut-show-info lockey "tut3.intro2" type middlecenter blocking #true portrait 2 }

			;; add offices

			{ #type tut-show-info lockey "tut3.pop.1" type topcenter blocking #true portrait 2 }

			{ #type tut-pan-camera pos { x 8 y 3 } blocking #true }
			{ #type tut-show-info lockey "tut3.pop.2" type topright portrait 2 }
			{ #type tut-wait-for-population count 20 }

			{ #type tut-show-info lockey "tut3.pop.3" type topcenter blocking #true portrait 2 }
			{ #type tut-show-info lockey "tut3.pop.4" type topright blocking #true portrait 2 }

			;; open consultants ribbon

			{ #type tut-hide-button-highlights }			
			{ #type tut-show-info lockey "tut3.decos.1" type topright portrait 2 }
			{ #type tut-show-arrow type left uiname "ui.build.consultants" offset { x 40 y 24 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-consultants" tabid "subribbon-consultants-art" }

			;; click on interior decorator

			{ #type tut-show-info lockey "tut3.decos.2" portrait 2 }
			{ #type tut-show-arrow type down uiname "ui.build.consultants.art.decorator" offset { x 24 y 40 } }
			{ #type tut-wait-for-buy-entity-input-mode template consultant-aesthetics }

			;; wait for placement

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut3.decos.3" portrait 2 }
			{ #type tut-wait-for-entity-count template consultant-aesthetics count 1 test atleast }

			;; wait for click on favors

			{ #type tut-show-info lockey "tut3.cons.1" type topcenter portrait 2 }
			{ #type tut-show-arrow type down uiname "RatingsTextFavors" offset { x 50 y 0 } }
			{ #type tut-wait-for-dialog type consultants showing #true }

			;; wait for click on small art works

			{ #type tut-show-info lockey "tut3.cons.2" type topright portrait 2 }
			{ #type tut-show-arrow type left uiname "Columns" offset { x -200 y 0 } }
			{ #type tut-wait-for-upgrade-active id "cons-a-1" }

			{ #type tut-hide-arrow }
			{ #type tut-wait-real-time realseconds 1 }

			{ #type tut-hide-info }
			{ #type tut-force-remove-popup type consultants }

			;; open art ribbon

			{ #type tut-pan-camera pos { x 0 y 1 } blocking #false }
			{ #type tut-show-info lockey "tut3.art.1" type topright portrait 2 }
			{ #type tut-show-arrow type left uiname "ui.build.arts" offset { x 40 y 24 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-art" tabid "subribbon-art-small" }

			;; wait for placement

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut3.art.2" type topright portrait 2 }
			{ #type tut-wait-for-prestige amount 1.1 test atleast }

			{ #type tut-show-info lockey "tut3.art.3" type topright blocking #true portrait 2 }

			;; done

			{ #type tut-show-info lockey "tut3.epilogue.1" type middlecenter blocking #true portrait 2 }
			{ #type tut-show-info lockey "tut3.epilogue.2" type topcenter blocking #true portrait 2 }

			{ #type tut-exit }
		]
	}


	{
		id 		 "tutorial4"
		locname  "tutorial4.name"
		locdesc  "tutorial4.desc"
		filename "Tutorial/Tutorial4"
		actions [

			{ #type tut-show-info lockey "tut4.intro.1" type middlecenter blocking #true portrait 1 }
			{ #type tut-show-info lockey "tut4.intro.2" type middlecenter blocking #true portrait 1 }

			;; look at tenant

			{ #type tut-pan-camera pos { x 0 y 2 } blocking #true seconds 1 }
			{ #type tut-show-info lockey "tut4.tenant.1" type topcenter portrait 1 }
			{ #type tut-show-arrow type down pos { x 0 y 2.7 } }
			{ #type tut-wait-for-dialog type unitinfo showing #true eid 168 }

			;; show ui

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut4.tenant.2" type topcenter portrait 1 }
			{ #type tut-show-arrow type down uiname "Renovate Button" offset { x 0 y 20 } }

			;; wait for repair scheduled

			{ #type tut-wait-for-service-pending eid 168 task taskrenovate expected #true }

			{ #type tut-hide-arrow }
			{ #type tut-force-deselect }
			{ #type tut-show-info lockey "tut4.tenant.3" type topright portrait 1 }

			;; wait for repair finished

			{ #type tut-wait-for-service-pending eid 168 task taskrenovate expected #false }

			{ #type tut-force-unpause }
			{ #type tut-show-info lockey "tut4.repairall.1" type topcenter blocking #true portrait 1 }

			;; pan, then click on maintenance office

			{ #type tut-pan-camera pos { x 0 y -1 } blocking #true seconds 1 }

			{ #type tut-show-info lockey "tut4.repairall.2" type topright portrait 1 }
			{ #type tut-show-arrow type down pos { x 1 y -0.3 } }
			{ #type tut-wait-for-dialog type unitinfo showing #true eid 158 }

			;; order repair

			{ #type tut-show-info lockey "tut4.repairall.3" type topcenter portrait 1 }
			{ #type tut-show-arrow type right uiname "Everything" offset { x 0 y -10 } }

			{ #type tut-wait-for-service-pending task taskrenovate expected #true }

			;; moving on to trash

			{ #type tut-hide-arrow }
			{ #type tut-force-deselect }
			{ #type tut-show-info lockey "tut4.repairall.4" type topright blocking #true portrait 1 }

			{ #type tut-show-info lockey "tut4.trashbin.1" type topcenter blocking #true portrait 1 }

			;; pan and wait for ribbon click

			{ #type tut-pan-camera pos { x -6 y 2 } blocking #true seconds 1 }
			{ #type tut-show-info lockey "tut4.trashbin.2" type topcenter portrait 1 }

			{ #type tut-show-arrow type down uiname "ui.build.floor" offset { x 24 y 40 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" }

			;; switch to trash

			{ #type tut-show-info lockey "tut4.trashbin.3" type topcenter portrait 1 }
			{ #type tut-show-arrow type right uiname "subribbon-special-trash" offset { x 15 y 12 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" tabid "subribbon-special-trash" }

			;; click on trash bin

			{ #type tut-show-info lockey "tut4.trashbin.4" type topcenter portrait 1 }
			{ #type tut-show-arrow type right uiname "ui.build.special.trash.bin" offset { x 10 y 28 } }
			{ #type tut-wait-for-buy-entity-input-mode template support-trashbin }

			;; place trash bin

			{ #type tut-hide-arrow }
			{ #type tut-show-highlight pos { x -10 y 2 } size { x 2 y 1 } }
			{ #type tut-show-info lockey "tut4.trashbin.5" type topright portrait 1 }

			{ #type tut-wait-for-entity-count template support-trashbin count 1 test atleast }

			;; place another trash bin

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut4.trashbin.6" type topcenter portrait 1 }
			{ #type tut-show-highlight pos { x -10 y 1 } size { x 2 y 1 } }

			{ #type tut-wait-for-entity-count template support-trashbin count 2 test atleast }

			;; move on to the basement

			{ #type tut-hide-highlight }
			{ #type tut-force-default-input-mode }

			{ #type tut-show-info lockey "tut4.trashroom.1" type topcenter blocking #true portrait 1 }
			{ #type tut-pan-camera pos { x 0 y -1 } blocking #true seconds 1 }

			{ #type tut-show-info lockey "tut4.trashroom.2" type topcenter blocking #true portrait 1 }

			;; click on the floor button

			{ #type tut-show-info lockey "tut4.trashroom.3" type topcenter portrait 1 }
			{ #type tut-show-arrow type down uiname "ui.build.floor" offset { x 24 y 40 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" }

			;; switch to trash

			{ #type tut-show-arrow type right uiname "subribbon-special-trash" offset { x 15 y 12 } }
			{ #type tut-wait-for-build-ribbon ribbonid "subribbon-floor" tabid "subribbon-special-trash" }

			;; click on trash room instead

			{ #type tut-show-info lockey "tut4.trashroom.4" type topcenter portrait 1 }
			{ #type tut-show-arrow type right uiname "ui.build.special.trash.room" offset { x 10 y 28 } }
			{ #type tut-wait-for-buy-entity-input-mode template support-trashroom }

			;; place trash room

			{ #type tut-hide-arrow }
			{ #type tut-show-highlight pos { x -5 y -2 } size { x 5 y 1 } }
			{ #type tut-show-info lockey "tut4.trashroom.5" type topright portrait 1 }

			{ #type tut-wait-for-entity-count template support-trashroom count 1 test atleast }

			;; done!

			{ #type tut-hide-highlight }
			{ #type tut-show-info lockey "tut4.trashroom.6" type topright blocking #true portrait 1 }

			;; epilogue

			{ #type tut-show-info lockey "tut4.epilogue.1" type middlecenter blocking #true portrait 1 }			
			{ #type tut-show-info lockey "tut4.epilogue.2" type topcenter blocking #true portrait 1 }			

			{ #type tut-exit }
		]
	}

	{
		id 		 "tutorialui"
		locname  "tutorialui.name"
		locdesc  "tutorialui.desc"
		filename "Tutorial/TutorialUI"
		actions [

			{ #type tut-pan-camera pos { x 0 y 2 } blocking #false seconds 0 }
			{ #type tut-show-info lockey "tut-ui.intro" type middlecenter blocking #true portrait 3 }

			;; build ribbon

			{ #type tut-show-info lockey "tut-ui.build.1" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type down uiname "SpeedButton1" offset { x 24 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.2" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type down uiname "MoneyText" offset { x 50 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.3" type topcenter blocking #true portrait 3 }
			{ #type tut-wait-for-dialog type budget showing #false }

			{ #type tut-show-info lockey "tut-ui.build.4" type topcenter blocking #false portrait 3 }
			{ #type tut-show-arrow type down uiname "LoanButton" offset { x 16 y 10 } }
			{ #type tut-wait-for-dialog type loans showing #true }

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut-ui.build.5" type topcenter blocking #false portrait 3 }
			{ #type tut-wait-for-dialog type loans showing #false }

			{ #type tut-show-arrow type down uiname "TextPrestige" offset { x 32 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.6" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type down uiname "TextResidents" offset { x 32 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.7" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type down uiname "RatingsTextBuzz" offset { x 50 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.8" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type down uiname "RatingsTextFavors" offset { x 50 y 10 } }
			{ #type tut-show-info lockey "tut-ui.build.9" type topcenter blocking #true portrait 3 }

			{ #type tut-show-arrow type right uiname "LoanButton" offset { x 70 y -20 } }
			{ #type tut-show-info lockey "tut-ui.build.10" type topcenter blocking #true portrait 3 }

			;; contracts / ada

			{ #type tut-show-arrow type down uiname "ui.build.contracts" offset { x 24 y 40 } }
			{ #type tut-show-info lockey "tut-ui.contr.1" type topcenter blocking #false portrait 3 }
			{ #type tut-wait-for-dialog type contracts showing #true }

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut-ui.contr.2" type topcenter blocking #false portrait 3 }
			{ #type tut-wait-for-dialog type contracts showing #false }

			{ #type tut-show-arrow type down uiname "ui.build.ada" offset { x 24 y 40 } }
			{ #type tut-show-info lockey "tut-ui.ada.1" type topcenter blocking #false portrait 3 }
			{ #type tut-wait-for-dialog type ada showing #true }

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut-ui.ada.2" type topcenter blocking #false portrait 3 }
			{ #type tut-wait-for-dialog type ada showing #false }

			;; layers

			{ #type tut-show-arrow type left uiname "Maps Button" offset { x 40 y 20 } }
			{ #type tut-show-info lockey "tut-ui.layers.1" type topcenter blocking #true portrait 3 }
			{ #type tut-hide-layers }

			{ #type tut-show-arrow type left uiname "Pipes Button" offset { x 40 y 20 } }
			{ #type tut-show-info lockey "tut-ui.layers.2" type topcenter blocking #true portrait 3 }
			{ #type tut-hide-layers }

			{ #type tut-show-arrow type left uiname "Grid Button" offset { x 40 y 20 } }
			{ #type tut-show-info lockey "tut-ui.layers.3" type topcenter blocking #true portrait 3 }
			{ #type tut-hide-layers }

			{ #type tut-show-arrow type down uiname "Options" offset { x -24 y 10 } }
			{ #type tut-show-info lockey "tut-ui.epilogue.1" type topcenter blocking #true portrait 3 }

			{ #type tut-hide-arrow }
			{ #type tut-show-info lockey "tut-ui.epilogue.2" type middlecenter blocking #true portrait 3 }
			{ #type tut-show-info lockey "tut-ui.epilogue.3" type topcenter blocking #true portrait 3 }

			{ #type tut-exit }
		]
	}



	]
}